(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     32262,       1021]*)
(*NotebookOutlinePosition[     47772,       1361]*)
(*  CellTagsIndexPosition[     46768,       1333]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Get Graphics Coordinates...", "Command",
  ShowCellBracket->False,
  CellTags->"GraphicsCoordinatesDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Get Graphics Coordinates", "SR"],
  " finds coordinates in graphics."
}], "Usage",
  ShowCellBracket->False,
  CellTags->"GraphicsCoordinatesDialog"],

Cell[TextData[
"\[FilledSmallSquare] When you choose this command, a help message is \
displayed that explains how to find graphics coordinates: It is not actually \
necessary to use this dialog once you know how to use the feature.\n\
\[FilledSmallSquare] To get coordinates in a 2D plot, select the plot, hold \
down the Command key,  and move the mouse over the area of the plot.  The \
coordinate values of the mouse position will be displayed in the window's \
status area.  If you click one or more times while holding down the Command \
key, the coordinates will be selected.  You can then copy and paste the \
coordinate values into an input cell."], "Notes",
  ShowCellBracket->False,
  CellTags->"GraphicsCoordinatesDialog"]
}, Open  ]],

Cell[CellGroupData[{

Cell["3D ViewPoint Selector...", "Command",
  ShowCellBracket->False,
  FontFamily->"Helvetica",
  CellTags->"ViewPointSelectorDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["3D ViewPoint Selector", "SR"],
  " lets you interactively select a viewpoint for three-dimensional \
graphics."
}], "Usage",
  ShowCellBracket->False,
  CellTags->"ViewPointSelectorDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["V", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["V", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["V", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  ShowCellBracket->False,
  AspectRatioFixed->False,
  CellTags->"viewPointSelectorID"],

Cell[TextData[{
  "\[FilledSmallSquare] The currently selected viewpoint is shown by a \
schematic cube with the ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontSlant->"Italic"],
  ", and",
  StyleBox[" z",
    FontSlant->"Italic"],
  " axes labeled. There are three ways of controlling the viewpoint:"
}], "Notes",
  ShowCellBracket->False,
  AspectRatioFixed->False,
  CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],

Cell["\<\
-  Drag the cube to change the orientation of the viewpoint without \
changing its distance from the cube.
-  Move the three scroll bars surrounding the cube.
-  Change the viewpoint coordinates in the editable text fields in the lower \
right of the dialog box.\
\>", "ItemizedText",
  ShowCellBracket->False,
  AspectRatioFixed->False,
  CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],

Cell[TextData[{
  "\[FilledSmallSquare] The text fields and scroll bars can be set to control \
either the spherical coordinates r, theta, and phi, or the Cartesian \
coordinates",
  StyleBox[" x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["z",
    FontSlant->"Italic"],
  ", by using the corresponding radio buttons."
}], "Notes",
  ShowCellBracket->False,
  AspectRatioFixed->False,
  CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],

Cell[TextData[
"\[FilledSmallSquare] Once you have chosen a viewpoint, Paste the input \
string describing it with the Paste button. The viewpoint input is pasted at \
the insertion point in the current notebook."], "Notes",
  ShowCellBracket->False,
  AspectRatioFixed->False,
  CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Color Selector...", "Command",
  ShowCellBracket->False,
  CellTags->"ColorSelectorDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Color Selector", "SR"],
  " lets you interactively select a color for ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " graphics. (Macintosh only)"
}], "Usage",
  ShowCellBracket->False,
  CellTags->"ColorSelectorDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] When you have chosen a color, click OK to paste the \
selected color at the text insertion point, cell insertion point, or \
selection within a cell, in the form of a ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " ",
  StyleBox["RGBColor[", "MR",
    FontFamily->"Courier"],
  StyleBox["red",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["green",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["blue",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  StyleBox["]", "MR",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontFamily->"Chicago",
    FontSize->9],
  "function. In this way you can specify the color of a graphical object \
without having to figure out the actual RGB values for the color yourself."
}], "Notes",
  ShowCellBracket->False,
  CellTags->"ColorSelectorDialog"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Record Sound...", "Command",
  ShowCellBracket->False,
  CellTags->"RecordSoundDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Record Sound", "SR"],
  " lets you record a sound into ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  ". (Macintosh only, microphone required)"
}], "Usage",
  ShowCellBracket->False,
  CellTags->"RecordSoundDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] With a sound recording peripheral connected to your \
computer, and the proper drivers installed, you can record sounds directly \
into ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  ". To record a sound, first place a cell insertion point (horizontal I-bar) \
in your notebook, then choose ",
  StyleBox["Record Sound", "SR"],
  ". A dialog box appears with buttons to control your recording. Once you \
have recorded a sound, click Save to paste the sound in your notebook. ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " can play recorded sounds just like sounds natively generated in ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  ".\n\[FilledSmallSquare] You can use the ",
  StyleBox["Convert to InputForm", "SR"],
  " command to convert recorded sounds into a list of numbers (samples) in \
the form of a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " list."
}], "Notes",
  ShowCellBracket->False,
  CellTags->"RecordSoundDialog"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Get File Path...", "Command",
  ShowCellBracket->False,
  CellTags->"FileNameDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Get File Path", "SR"],
  " pastes the full pathname of a selected file into the text."
}], "Usage",
  ShowCellBracket->False,
  CellTags->"FileNameDialog"],

Cell[TextData[
"\[FilledSmallSquare] When a file is selected, clicking Open pastes the full \
pathname of the file into the notebook at the current selection."], "Notes",
  ShowCellBracket->False,
  CellTags->"FileNameDialog"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create Table/Matrix/Palette...", "Command",
  ShowCellBracket->False,
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],

Cell[TextData[{
  StyleBox["Create Table/Matrix/Palette", "SR"],
  " sets up an empty ",
  StyleBox["GridBox", "Input"],
  " object."
}], "Usage",
  ShowCellBracket->False,
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],

Cell[TextData[StyleBox["Table",
  FontWeight->"Bold"]], "DialogItem",
  ShowCellBracket->False,
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],

Cell[TextData[{
  "Makes a ",
  StyleBox["GridBox", "Input"],
  " with no special options."
}], "IndentedText",
  ShowCellBracket->False,
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],

Cell[TextData[StyleBox["Matrix",
  FontWeight->"Bold"]], "DialogItem",
  ShowCellBracket->False,
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],

Cell["\<\
Rows and columns are the width of the widest element with \
parentheses around the matrix.\
\>", "IndentedText",
  ShowCellBracket->False,
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],

Cell[TextData[StyleBox["Palette",
  FontWeight->"Bold"]], "DialogItem",
  ShowCellBracket->False,
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],

Cell[TextData[{
  "Makes a ",
  StyleBox["GridBox", "Input"],
  " filled with buttons, with various options set to give the appearance of a \
palette."
}], "IndentedText",
  ShowCellBracket->False,
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],

Cell[TextData[StyleBox["Fill with",
  FontWeight->"Bold"]], "DialogItem",
  ShowCellBracket->False,
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],

Cell["\<\
Sets the initial values for the elements with the specified \
value.\
\>", "IndentedText",
  ShowCellBracket->False,
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],

Cell[TextData[StyleBox["Fill diagonal",
  FontWeight->"Bold"]], "DialogItem",
  ShowCellBracket->False,
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],

Cell["\<\
Sets the initial values for diagonal elements with the specified \
value. Can be used in conjunction with \"Fill with\".\
\>", "IndentedText",
  ShowCellBracket->False,
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["GridBox",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  ShowCellBracket->False,
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["C", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["C", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["C", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  ShowCellBracket->False,
  AspectRatioFixed->False,
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialog"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create Button", "Command",
  ShowCellBracket->False,
  CellTags->"CreateCustomButtonBox"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Create Button", "SR"],
  " sets up a single button with the specified action, or a custom action."
}], "Usage",
  ShowCellBracket->False,
  CellTags->"CreateCustomButtonBox"],

Cell[TextData[
"\[FilledSmallSquare] The submenu lets you select standard button functions \
that are defined in the style sheet associated with the current notebook."], 
  "Notes",
  ShowCellBracket->False,
  CellTags->"CreateCustomButtonBox"],

Cell[TextData[{
  "\[FilledSmallSquare] See the ",
  StyleBox["Mathematica", "TI"],
  " book:  ",
  ButtonBox["Section 2.10.6",
    ButtonData:>{"2.10.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  ShowCellBracket->False,
  CellTags->"CreateCustomButtonBox"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Edit Button", "Command",
  ShowCellBracket->False,
  CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Edit Button", "SR"],
  " lets you edit the action for the selected button and specify ",
  StyleBox["ButtonBox", "MR"],
  " options."
}], "Usage",
  ShowCellBracket->False,
  CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],

Cell[TextData[
"\[FilledSmallSquare] The Button Style pop-up menu lets you select standard \
button functions that are defined in the style sheet associated with the \
current notebook.\n\[FilledSmallSquare] The other items in the dialog box can \
be used to set individual options associated with the button."], "Notes",
  ShowCellBracket->False,
  CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["ButtonBox",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonData",
    ButtonStyle->"RefGuideLink"],
  ",  ",
  ButtonBox["ButtonFunction",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonEvaluator",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonNote",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonSource",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonStyle",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  ShowCellBracket->False,
  CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] See the ",
  StyleBox["Mathematica", "TI"],
  " book:  ",
  ButtonBox["Section 2.10.6",
    ButtonData:>{"2.10.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  ShowCellBracket->False,
  CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create Hyperlink...", "Command",
  ShowCellBracket->False,
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Create Hyperlink", "SR"],
  " sets up a hyperlink to a specified cell, notebook or URL."
}], "Usage",
  ShowCellBracket->False,
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],

Cell[TextData[{
  "1. Select the words you want to make into a hyperlink.\n2. Choose",
  StyleBox[" Create Hyperlink", "SR"],
  ".\n3. Specify a destination for the link. The destination can be a \
notebook, or cells in a notebook.\n4. Click OK."
}], "ItemizedText",
  ShowCellBracket->False,
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],

Cell[TextData[{
  "   The selected text is formatted as a hyperlink button (typically \
underlined). When you click the hyperlink, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will jump to the linked cell or notebook."
}], "Notes",
  ShowCellBracket->False,
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],

Cell[TextData[{
  " \[FilledSmallSquare] Cells are targeted by use of cell tags. If your \
destination cells do not already have cell tags you must add them first by \
using the ",
  StyleBox["Add/Remove Cell Tags", "SR"],
  " command in the Find menu."
}], "Notes",
  ShowCellBracket->False,
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],

Cell[TextData[{
  " \[FilledSmallSquare] On some versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " you can also link to a URL. Enter the URL in the text field at the top of \
the dialog box. Such a link will automatically open your web browser and \
connect to the designated web address. URL prefixes include \"",
  StyleBox["http://", "MR"],
  "\", \"",
  StyleBox["mailto:", "MR"],
  "\", \"",
  StyleBox["news:", "MR"],
  "\", and \"",
  StyleBox["ftp:", "MR"],
  "\"."
}], "Notes",
  ShowCellBracket->False,
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] When you click the hyperlink button, it jumps to the \
referenced cell.  If you want to jump to this cell from a different notebook, \
check \"Include file name in link destination\".\n\[FilledSmallSquare] A \
hyperlink is a ",
  StyleBox["ButtonBox", "MR"],
  " object with the options",
  StyleBox[" ButtonStyle\[Rule]\"Hyperlink\"", "MR"],
  " and ",
  StyleBox["ButtonData\[Rule]\"", "MR"],
  StyleBox["destination", "MR",
    FontSlant->"Italic"],
  StyleBox["\"", "MR"],
  ".\n\[FilledSmallSquare] To edit the name of a hyperlink button, click \
beside the button and use the arrow keys to move the insertion point into the \
button's text."
}], "Notes",
  ShowCellBracket->False,
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["NotebookLocate",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  ShowCellBracket->False,
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] See the ",
  StyleBox["Mathematica", "TI"],
  " book: ",
  ButtonBox["Section 1.10.13",
    ButtonData:>{"1.10.13"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Text",
  ShowCellBracket->False,
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also ",
  Cell[BoxData[
      ButtonBox[\(Add/Remove\ Cell\ Tags\),
        Active->True,
        ButtonStyle->"OtherInformationLink"]]]
}], "Notes",
  ShowCellBracket->False,
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create Automatic Numbering Object...", "Command",
  ShowCellBracket->False,
  CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Create Automatic Numbering Object", "SR"],
  " sets up automatic numbering in the current notebook."
}], "Usage",
  ShowCellBracket->False,
  CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] The counters available in a particular notebook are \
usually defined by the style sheet.  The default style sheet defines counters \
named \"Section\", \"Subsection\", \"Subsubsection\", \"Equation\", \
\"Figure\", and \"Table\".\n\[FilledSmallSquare] Counter values can be \
displayed either as they exist at the location of the display, or as they \
exist at a remote location defined by a cell tag.\n\[FilledSmallSquare] A \
counter named \"Page\" is always available, but it is only valid when the \
option to show page breaks is turned on.\n\[FilledSmallSquare] Counter values \
are set and incremented by the options ",
  StyleBox["CounterAssignements", "MR"],
  " and ",
  StyleBox["CounterIncrements", "MR"],
  ".\n\[FilledSmallSquare] Counter display can be controlled using the \
options ",
  StyleBox["CounterFunction", "MR"],
  " and ",
  StyleBox["CounterData", "MR"],
  "."
}], "Notes",
  ShowCellBracket->False,
  CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] See the ",
  StyleBox["Mathematica", "TI"],
  " book: ",
  ButtonBox["Section 1.10.14",
    ButtonData:>{"1.10.14"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Text",
  ShowCellBracket->False,
  CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create Value Display Object...", "Command",
  ShowCellBracket->False,
  CellTags->{"CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Create Value Display Object ", "SR"],
  StyleBox[
  "sets up an object in your notebook to display the values of a specified \
option.", "Text"]
}], "Usage",
  ShowCellBracket->False,
  CellTags->{"CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}]
}, Open  ]],

Cell[TextData[
"\[FilledSmallSquare] The value of the specified option is displayed as it \
would appear in the Option Inspector, and automatically updated if the option \
value changes.\n\[FilledSmallSquare] Option values can be displayed either as \
they exist at the location of the display, or as they exist at a remote \
location defined by a cell tag.\n\[FilledSmallSquare] In addition to any \
option value, the following names can be used to display other values:"], 
  "Notes",
  ShowCellBracket->False,
  CellTags->{"CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],

Cell[BoxData[
    StyleBox[
      "\(FileName\\n       PathName\\n       MemoryInUse\\n       \
FreeMemory\\n       ClipboardMemoryInUse\\n       $UserName\\n       \
$MachineName\\n       $Version\\n       $FullVersion\\n       \
$VersionNumber\\n       $System\\n       $ReleaseNumber\\n       \
$MinorReleaseNumber\\n       $CreationDate\\n       $MachineID\\n       \
$MachineType\\n       $OperatingSystem\\n       $ProcessorType\\n       \
$ProgramName\\n       $SystemID\\n       $TopDirectory\\n       \
$LaunchDirectory\\n       HomeDirectory\\n       $InitialDirectory\\n       \
$EvaluationDirectory\\n       Date\\n       DateLong\\n       Time\\n       \
Year\\n       Month\\n       MonthName\\n       Day\\n       Hour\\n       \
Minute\\n       Second\\n       $ExpirationDate\\n       \
$LicenseExpirationDate\\n       $ExpirationString\\t\\n       \
$RegistrationUserName\\n       $RegistrationOrganization\\n       \
$LicenseID\)",
      "MR"]], "Input",
  ShowCellBracket->False,
  CellMargins->{{72, Inherited}, {Inherited, Inherited}},
  CellTags->{"CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],

Cell[CellGroupData[{

Cell["Copy Input From Above", "Command",
  ShowCellBracket->False,
  CellTags->"DuplicatePreviousInput"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Copy Input From Above", "SR"],
  " copies the contents of the nearest input cell above."
}], "Usage",
  ShowCellBracket->False,
  CellTags->"DuplicatePreviousInput"],

Cell[TextData[
"\[FilledSmallSquare] This command copies the contents of the nearest active \
cell above your insertion point, and then pastes it at the insertion point."],
   "Notes",
  ShowCellBracket->False,
  CellTags->"DuplicatePreviousInput"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["l", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["l", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["l", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  ShowCellBracket->False,
  AspectRatioFixed->False,
  CellTags->"DuplicatePreviousInput"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Copy Output From Above", "Command",
  ShowCellBracket->False,
  CellTags->"DuplicatePreviousOutput"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Copy Output From Above", "SR"],
  " copies the contents of the nearest output cell above."
}], "Usage",
  ShowCellBracket->False,
  CellTags->"DuplicatePreviousOutput"],

Cell[TextData[
"\[FilledSmallSquare] This command copies the contents of the nearest output \
cell above your insertion point, and then pastes it at the insertion point."],
   "Notes",
  ShowCellBracket->False,
  CellTags->"DuplicatePreviousOutput"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["L", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["L", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["L", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  ShowCellBracket->False,
  AspectRatioFixed->False,
  CellTags->"DuplicatePreviousOutput"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Start New Cell Below", "Command",
  ShowCellBracket->False,
  CellTags->"SimilarCellBelow"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Start New Cell Below", "SR"],
  " creates a new cell with inherited properties below the current cell."
}], "Usage",
  ShowCellBracket->False,
  CellTags->"SimilarCellBelow"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[AltKey]\[KeyBar]\[EnterKey] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[OptionKey]\[KeyBar]\[ReturnKey] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[Mod2Key]-\[ReturnKey] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  ShowCellBracket->False,
  AspectRatioFixed->False,
  CellTags->"SimilarCellBelow"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Complete Selection", "Command",
  ShowCellBracket->False,
  CellTags->"CompleteSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Complete Selection", "SR"],
  " completes a partially typed function name. "
}], "Usage",
  ShowCellBracket->False,
  CellTags->"CompleteSelection"],

Cell[TextData[
"\[FilledSmallSquare] This command reads your current selection (which should \
be a single word, or an insertion point following a word) and looks up \
possible completions in the list of all currently defined functions and \
variables."], "Notes",
  ShowCellBracket->False,
  CellTags->"CompleteSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] This command works only when you are connected to a ",
  
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " kernel."
}], "Notes",
  ShowCellBracket->False,
  CellTags->"CompleteSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] When there is only one possible completion, ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " automatically inserts the additional characters to finish what you have \
typed. Otherwise, a pop-up menu lists the various possible completions. To \
insert one of them, click the completion you want, or type another letter to \
reduce the list of possible completions. "
}], "Notes",
  ShowCellBracket->False,
  CellTags->"CompleteSelection"],

Cell[TextData[
"\[FilledSmallSquare] Press Backspace to cancel the pop-up menu."], "Notes",
  ShowCellBracket->False,
  CellTags->"CompleteSelection"],

Cell[TextData[
"\[FilledSmallSquare] If the list is long, you can scroll the menu by moving \
the mouse up or down, or by using the arrow keys."], "Notes",
  ShowCellBracket->False,
  CellTags->"CompleteSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["k", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["k", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["k", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  ShowCellBracket->False,
  AspectRatioFixed->False,
  CellTags->"CompleteSelection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Make Template", "Command",
  ShowCellBracket->False,
  CellTags->"TemplateSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Make Template", "SR"],
  " inserts a template based on the currently selected function name. "
}], "Usage",
  ShowCellBracket->False,
  CellTags->"TemplateSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] This command reads your current selection (which \
should be a function name or insertion point after a function name) and adds \
a template for the arguments it can take. For example, if your selection is ",
  
  StyleBox["Plot", "MR",
    FontFamily->"Courier"],
  " you get ",
  StyleBox["Plot[f, {x, xmin, xmax}]", "MR",
    FontFamily->"Courier"],
  ", which shows the simplest form of the ",
  StyleBox["Plot", "MR",
    FontFamily->"Courier"],
  " function. "
}], "Notes",
  ShowCellBracket->False,
  CellTags->"TemplateSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] You can only get function templates when you are \
connected to a ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " kernel. To define a function template for a user-defined function, make \
the template the first statement in the \"usage\" message for the function. \
For example, to define the template ",
  StyleBox["f[a,b]", "MR",
    FontFamily->"Courier"],
  " for the function f, you could use the following command:\n",
  StyleBox[" ",
    FontFamily->"Courier"],
  StyleBox["f::usage = \"f[a,b] is an example of a function\"", "MR",
    FontFamily->"Courier"]
}], "Notes",
  ShowCellBracket->False,
  CellTags->"TemplateSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] Note that the templates you get for built-in \
functions are usually only one of several possible argument forms. Use the \
kernel command ",
  StyleBox["?", "MR",
    FontFamily->"Courier"],
  " to get more information, or see the ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " book for a complete description of a given command."
}], "Notes",
  ShowCellBracket->False,
  CellTags->"TemplateSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] When you choose ",
  StyleBox["Make Template", "SR"],
  " after typing a partial word, ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " looks to the left of the insertion point to find a suitable function or \
variable name. When this name is not a currently defined function, ",
  StyleBox["Make Template", "SR"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "applies the ",
  StyleBox["Complete Selection", "SR"],
  " command before attempting to make a template."
}], "Notes",
  ShowCellBracket->False,
  CellTags->"TemplateSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["K", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["K", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["K", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  ShowCellBracket->False,
  AspectRatioFixed->False,
  CellTags->"TemplateSelection"]
}, Open  ]]
},
FrontEndVersion->"NeXT 3.0",
ScreenRectangle->{{0, 1053}, {0, 832}},
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{520, 365},
WindowMargins->{{8, Automatic}, {Automatic, 20}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
ShowCellBracket->False,
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "GraphicsCoordinatesDialog"->{
    Cell[1731, 51, 113, 2, 34, "Command",
      CellTags->"GraphicsCoordinatesDialog"],
    Cell[1847, 55, 204, 6, 29, "Usage",
      CellTags->"GraphicsCoordinatesDialog"],
    Cell[2054, 63, 734, 11, 112, "Notes",
      CellTags->"GraphicsCoordinatesDialog"]},
  "ViewPointSelectorDialog"->{
    Cell[2825, 79, 135, 3, 34, "Command",
      CellTags->"ViewPointSelectorDialog"],
    Cell[2963, 84, 244, 7, 29, "Usage",
      CellTags->"ViewPointSelectorDialog"],
    Cell[3895, 114, 461, 15, 36, "Notes",
      CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],
    Cell[4359, 131, 411, 9, 80, "ItemizedText",
      CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],
    Cell[4773, 142, 505, 16, 36, "Notes",
      CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],
    Cell[5281, 160, 341, 6, 36, "Notes",
      CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}]},
  "viewPointSelectorID"->{
    Cell[3210, 93, 682, 19, 22, "Notes",
      CellTags->"viewPointSelectorID"],
    Cell[3895, 114, 461, 15, 36, "Notes",
      CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],
    Cell[4359, 131, 411, 9, 80, "ItemizedText",
      CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],
    Cell[4773, 142, 505, 16, 36, "Notes",
      CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],
    Cell[5281, 160, 341, 6, 36, "Notes",
      CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}]},
  "ColorSelectorDialog"->{
    Cell[5659, 171, 97, 2, 34, "Command",
      CellTags->"ColorSelectorDialog"],
    Cell[5759, 175, 315, 10, 29, "Usage",
      CellTags->"ColorSelectorDialog"],
    Cell[6077, 187, 1135, 38, 64, "Notes",
      CellTags->"ColorSelectorDialog"]},
  "RecordSoundDialog"->{
    Cell[7249, 230, 93, 2, 34, "Command",
      CellTags->"RecordSoundDialog"],
    Cell[7345, 234, 310, 10, 29, "Usage",
      CellTags->"RecordSoundDialog"],
    Cell[7658, 246, 1110, 28, 126, "Notes",
      CellTags->"RecordSoundDialog"]},
  "FileNameDialog"->{
    Cell[8805, 279, 91, 2, 34, "Command",
      CellTags->"FileNameDialog"],
    Cell[8899, 283, 210, 6, 29, "Usage",
      CellTags->"FileNameDialog"],
    Cell[9112, 291, 226, 4, 36, "Notes",
      CellTags->"FileNameDialog"]},
  "CreateGridBoxDialog"->{
    Cell[9375, 300, 137, 2, 34, "Command",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[9515, 304, 234, 7, 29, "Usage",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[9752, 313, 157, 3, 25, "DialogItem",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[9912, 318, 199, 6, 20, "IndentedText",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[10114, 326, 158, 3, 25, "DialogItem",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[10275, 331, 210, 5, 20, "IndentedText",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[10488, 338, 159, 3, 25, "DialogItem",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[10650, 343, 259, 7, 20, "IndentedText",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[10912, 352, 161, 3, 25, "DialogItem",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[11076, 357, 188, 5, 20, "IndentedText",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[11267, 364, 165, 3, 25, "DialogItem",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[11435, 369, 240, 5, 34, "IndentedText",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[11678, 376, 216, 7, 22, "Notes",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[11897, 385, 708, 19, 22, "Notes",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialog"}]},
  "createGridBoxDialogID"->{
    Cell[9375, 300, 137, 2, 34, "Command",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[9515, 304, 234, 7, 29, "Usage",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[9752, 313, 157, 3, 25, "DialogItem",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[9912, 318, 199, 6, 20, "IndentedText",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[10114, 326, 158, 3, 25, "DialogItem",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[10275, 331, 210, 5, 20, "IndentedText",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[10488, 338, 159, 3, 25, "DialogItem",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[10650, 343, 259, 7, 20, "IndentedText",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[10912, 352, 161, 3, 25, "DialogItem",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[11076, 357, 188, 5, 20, "IndentedText",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[11267, 364, 165, 3, 25, "DialogItem",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[11435, 369, 240, 5, 34, "IndentedText",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[11678, 376, 216, 7, 22, "Notes",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}]},
  "createGridBoxDialog"->{
    Cell[11897, 385, 708, 19, 22, "Notes",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialog"}]},
  "CreateCustomButtonBox"->{
    Cell[12642, 409, 95, 2, 34, "Command",
      CellTags->"CreateCustomButtonBox"],
    Cell[12740, 413, 229, 6, 29, "Usage",
      CellTags->"CreateCustomButtonBox"],
    Cell[12972, 421, 244, 5, 36, "Notes",
      CellTags->"CreateCustomButtonBox"],
    Cell[13219, 428, 271, 10, 22, "Notes",
      CellTags->"CreateCustomButtonBox"]},
  "EditButtonBoxDialog"->{
    Cell[13527, 443, 124, 2, 34, "Command",
      CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],
    Cell[13654, 447, 295, 8, 29, "Usage",
      CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],
    Cell[13952, 457, 415, 6, 56, "Notes",
      CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],
    Cell[14370, 465, 656, 25, 36, "Notes",
      CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],
    Cell[15029, 492, 302, 10, 22, "Notes",
      CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}]},
  "editButtonBoxScriptDialogID"->{
    Cell[13527, 443, 124, 2, 34, "Command",
      CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],
    Cell[13654, 447, 295, 8, 29, "Usage",
      CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],
    Cell[13952, 457, 415, 6, 56, "Notes",
      CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],
    Cell[14370, 465, 656, 25, 36, "Notes",
      CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],
    Cell[15029, 492, 302, 10, 22, "Notes",
      CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}]},
  "CreateHyperlinkDialog"->{
    Cell[15368, 507, 123, 2, 34, "Command",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[15494, 511, 241, 6, 29, "Usage",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[15738, 519, 351, 7, 88, "ItemizedText",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[16092, 528, 330, 8, 36, "Notes",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[16425, 538, 351, 8, 36, "Notes",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[16779, 548, 592, 17, 64, "Notes",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[17374, 567, 785, 18, 104, "Notes",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[18162, 587, 231, 7, 22, "Notes",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[18396, 596, 293, 10, 22, "Text",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[18692, 608, 278, 8, 22, "Notes",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}]},
  "copyLinkDialogID"->{
    Cell[15368, 507, 123, 2, 34, "Command",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[15494, 511, 241, 6, 29, "Usage",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[15738, 519, 351, 7, 88, "ItemizedText",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[16092, 528, 330, 8, 36, "Notes",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[16425, 538, 351, 8, 36, "Notes",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[16779, 548, 592, 17, 64, "Notes",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[17374, 567, 785, 18, 104, "Notes",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[18162, 587, 231, 7, 22, "Notes",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[18396, 596, 293, 10, 22, "Text",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[18692, 608, 278, 8, 22, "Notes",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}]},
  "CreateCounterBoxDialog"->{
    Cell[19007, 621, 149, 2, 34, "Command",
      CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],
    Cell[19159, 625, 262, 6, 29, "Usage",
      CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],
    Cell[19424, 633, 1035, 21, 172, "Notes",
      CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],
    Cell[20462, 656, 302, 10, 22, "Text",
      CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}]},
  "createCounterBoxDialogID"->{
    Cell[19007, 621, 149, 2, 34, "Command",
      CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],
    Cell[19159, 625, 262, 6, 29, "Usage",
      CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],
    Cell[19424, 633, 1035, 21, 172, "Notes",
      CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],
    Cell[20462, 656, 302, 10, 22, "Text",
      CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}]},
  "CreateOptionValueBoxDialog"->{
    Cell[20801, 671, 151, 2, 34, "Command",
      CellTags->{
      "CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],
    Cell[20955, 675, 314, 8, 43, "Usage",
      CellTags->{
      "CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],
    Cell[21284, 686, 588, 9, 90, "Notes",
      CellTags->{
      "CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],
    Cell[21875, 697, 1133, 19, 568, "Input",
      CellTags->{
      "CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}]},
  "createOptionValueBoxDialogID"->{
    Cell[20801, 671, 151, 2, 34, "Command",
      CellTags->{
      "CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],
    Cell[20955, 675, 314, 8, 43, "Usage",
      CellTags->{
      "CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],
    Cell[21284, 686, 588, 9, 90, "Notes",
      CellTags->{
      "CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],
    Cell[21875, 697, 1133, 19, 568, "Input",
      CellTags->{
      "CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}]},
  "DuplicatePreviousInput"->{
    Cell[23033, 720, 104, 2, 34, "Command",
      CellTags->"DuplicatePreviousInput"],
    Cell[23140, 724, 220, 6, 29, "Usage",
      CellTags->"DuplicatePreviousInput"],
    Cell[23363, 732, 248, 5, 36, "Notes",
      CellTags->"DuplicatePreviousInput"],
    Cell[23614, 739, 626, 19, 22, "Notes",
      CellTags->"DuplicatePreviousInput"]},
  "DuplicatePreviousOutput"->{
    Cell[24277, 763, 106, 2, 34, "Command",
      CellTags->"DuplicatePreviousOutput"],
    Cell[24386, 767, 223, 6, 29, "Usage",
      CellTags->"DuplicatePreviousOutput"],
    Cell[24612, 775, 249, 5, 36, "Notes",
      CellTags->"DuplicatePreviousOutput"],
    Cell[24864, 782, 687, 19, 22, "Notes",
      CellTags->"DuplicatePreviousOutput"]},
  "SimilarCellBelow"->{
    Cell[25588, 806, 97, 2, 34, "Command",
      CellTags->"SimilarCellBelow"],
    Cell[25688, 810, 229, 6, 29, "Usage",
      CellTags->"SimilarCellBelow"],
    Cell[25920, 818, 435, 13, 22, "Notes",
      CellTags->"SimilarCellBelow"]},
  "CompleteSelection"->{
    Cell[26392, 836, 96, 2, 34, "Command",
      CellTags->"CompleteSelection"],
    Cell[26491, 840, 203, 6, 29, "Usage",
      CellTags->"CompleteSelection"],
    Cell[26697, 848, 323, 6, 50, "Notes",
      CellTags->"CompleteSelection"],
    Cell[27023, 856, 264, 9, 22, "Notes",
      CellTags->"CompleteSelection"],
    Cell[27290, 867, 517, 11, 70, "Notes",
      CellTags->"CompleteSelection"],
    Cell[27810, 880, 150, 3, 70, "Notes",
      CellTags->"CompleteSelection"],
    Cell[27963, 885, 214, 4, 70, "Notes",
      CellTags->"CompleteSelection"],
    Cell[28180, 891, 621, 19, 70, "Notes",
      CellTags->"CompleteSelection"]},
  "TemplateSelection"->{
    Cell[28838, 915, 91, 2, 70, "Command",
      CellTags->"TemplateSelection"],
    Cell[28932, 919, 221, 6, 70, "Usage",
      CellTags->"TemplateSelection"],
    Cell[29156, 927, 578, 16, 70, "Notes",
      CellTags->"TemplateSelection"],
    Cell[29737, 945, 718, 18, 70, "Notes",
      CellTags->"TemplateSelection"],
    Cell[30458, 965, 485, 13, 70, "Notes",
      CellTags->"TemplateSelection"],
    Cell[30946, 980, 616, 17, 70, "Notes",
      CellTags->"TemplateSelection"],
    Cell[31565, 999, 681, 19, 70, "Notes",
      CellTags->"TemplateSelection"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"GraphicsCoordinatesDialog", 33041, 1044},
  {"ViewPointSelectorDialog", 33335, 1051},
  {"viewPointSelectorID", 33982, 1064},
  {"ColorSelectorDialog", 34540, 1075},
  {"RecordSoundDialog", 34813, 1082},
  {"FileNameDialog", 35078, 1089},
  {"CreateGridBoxDialog", 35335, 1096},
  {"createGridBoxDialogID", 36948, 1125},
  {"createGridBoxDialog", 38451, 1152},
  {"CreateCustomButtonBox", 38589, 1155},
  {"EditButtonBoxDialog", 38955, 1164},
  {"editButtonBoxScriptDialogID", 39570, 1175},
  {"CreateHyperlinkDialog", 40179, 1186},
  {"copyLinkDialogID", 41276, 1207},
  {"CreateCounterBoxDialog", 42379, 1228},
  {"createCounterBoxDialogID", 42877, 1237},
  {"CreateOptionValueBoxDialog", 43377, 1246},
  {"createOptionValueBoxDialogID", 43939, 1259},
  {"DuplicatePreviousInput", 44495, 1272},
  {"DuplicatePreviousOutput", 44870, 1281},
  {"SimilarCellBelow", 45242, 1290},
  {"CompleteSelection", 45507, 1297},
  {"TemplateSelection", 46176, 1314}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 113, 2, 34, "Command",
  CellTags->"GraphicsCoordinatesDialog"],
Cell[1847, 55, 204, 6, 29, "Usage",
  CellTags->"GraphicsCoordinatesDialog"],
Cell[2054, 63, 734, 11, 112, "Notes",
  CellTags->"GraphicsCoordinatesDialog"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2825, 79, 135, 3, 34, "Command",
  CellTags->"ViewPointSelectorDialog"],
Cell[2963, 84, 244, 7, 29, "Usage",
  CellTags->"ViewPointSelectorDialog"],
Cell[3210, 93, 682, 19, 22, "Notes",
  CellTags->"viewPointSelectorID"],
Cell[3895, 114, 461, 15, 36, "Notes",
  CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],
Cell[4359, 131, 411, 9, 80, "ItemizedText",
  CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],
Cell[4773, 142, 505, 16, 36, "Notes",
  CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],
Cell[5281, 160, 341, 6, 36, "Notes",
  CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[5659, 171, 97, 2, 34, "Command",
  CellTags->"ColorSelectorDialog"],
Cell[5759, 175, 315, 10, 29, "Usage",
  CellTags->"ColorSelectorDialog"],
Cell[6077, 187, 1135, 38, 64, "Notes",
  CellTags->"ColorSelectorDialog"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7249, 230, 93, 2, 34, "Command",
  CellTags->"RecordSoundDialog"],
Cell[7345, 234, 310, 10, 29, "Usage",
  CellTags->"RecordSoundDialog"],
Cell[7658, 246, 1110, 28, 126, "Notes",
  CellTags->"RecordSoundDialog"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8805, 279, 91, 2, 34, "Command",
  CellTags->"FileNameDialog"],
Cell[8899, 283, 210, 6, 29, "Usage",
  CellTags->"FileNameDialog"],
Cell[9112, 291, 226, 4, 36, "Notes",
  CellTags->"FileNameDialog"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9375, 300, 137, 2, 34, "Command",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
Cell[9515, 304, 234, 7, 29, "Usage",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
Cell[9752, 313, 157, 3, 25, "DialogItem",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
Cell[9912, 318, 199, 6, 20, "IndentedText",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
Cell[10114, 326, 158, 3, 25, "DialogItem",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
Cell[10275, 331, 210, 5, 20, "IndentedText",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
Cell[10488, 338, 159, 3, 25, "DialogItem",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
Cell[10650, 343, 259, 7, 20, "IndentedText",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
Cell[10912, 352, 161, 3, 25, "DialogItem",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
Cell[11076, 357, 188, 5, 20, "IndentedText",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
Cell[11267, 364, 165, 3, 25, "DialogItem",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
Cell[11435, 369, 240, 5, 34, "IndentedText",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
Cell[11678, 376, 216, 7, 22, "Notes",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
Cell[11897, 385, 708, 19, 22, "Notes",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialog"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[12642, 409, 95, 2, 34, "Command",
  CellTags->"CreateCustomButtonBox"],
Cell[12740, 413, 229, 6, 29, "Usage",
  CellTags->"CreateCustomButtonBox"],
Cell[12972, 421, 244, 5, 36, "Notes",
  CellTags->"CreateCustomButtonBox"],
Cell[13219, 428, 271, 10, 22, "Notes",
  CellTags->"CreateCustomButtonBox"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13527, 443, 124, 2, 34, "Command",
  CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],
Cell[13654, 447, 295, 8, 29, "Usage",
  CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],
Cell[13952, 457, 415, 6, 56, "Notes",
  CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],
Cell[14370, 465, 656, 25, 36, "Notes",
  CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],
Cell[15029, 492, 302, 10, 22, "Notes",
  CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[15368, 507, 123, 2, 34, "Command",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
Cell[15494, 511, 241, 6, 29, "Usage",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
Cell[15738, 519, 351, 7, 88, "ItemizedText",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
Cell[16092, 528, 330, 8, 36, "Notes",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
Cell[16425, 538, 351, 8, 36, "Notes",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
Cell[16779, 548, 592, 17, 64, "Notes",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
Cell[17374, 567, 785, 18, 104, "Notes",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
Cell[18162, 587, 231, 7, 22, "Notes",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
Cell[18396, 596, 293, 10, 22, "Text",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
Cell[18692, 608, 278, 8, 22, "Notes",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[19007, 621, 149, 2, 34, "Command",
  CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],
Cell[19159, 625, 262, 6, 29, "Usage",
  CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],
Cell[19424, 633, 1035, 21, 172, "Notes",
  CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],
Cell[20462, 656, 302, 10, 22, "Text",
  CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[20801, 671, 151, 2, 34, "Command",
  CellTags->{"CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],
Cell[20955, 675, 314, 8, 43, "Usage",
  CellTags->{"CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}]
}, Open  ]],
Cell[21284, 686, 588, 9, 90, "Notes",
  CellTags->{"CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],
Cell[21875, 697, 1133, 19, 568, "Input",
  CellTags->{"CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],

Cell[CellGroupData[{
Cell[23033, 720, 104, 2, 34, "Command",
  CellTags->"DuplicatePreviousInput"],
Cell[23140, 724, 220, 6, 29, "Usage",
  CellTags->"DuplicatePreviousInput"],
Cell[23363, 732, 248, 5, 36, "Notes",
  CellTags->"DuplicatePreviousInput"],
Cell[23614, 739, 626, 19, 22, "Notes",
  CellTags->"DuplicatePreviousInput"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24277, 763, 106, 2, 34, "Command",
  CellTags->"DuplicatePreviousOutput"],
Cell[24386, 767, 223, 6, 29, "Usage",
  CellTags->"DuplicatePreviousOutput"],
Cell[24612, 775, 249, 5, 36, "Notes",
  CellTags->"DuplicatePreviousOutput"],
Cell[24864, 782, 687, 19, 22, "Notes",
  CellTags->"DuplicatePreviousOutput"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25588, 806, 97, 2, 34, "Command",
  CellTags->"SimilarCellBelow"],
Cell[25688, 810, 229, 6, 29, "Usage",
  CellTags->"SimilarCellBelow"],
Cell[25920, 818, 435, 13, 22, "Notes",
  CellTags->"SimilarCellBelow"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26392, 836, 96, 2, 34, "Command",
  CellTags->"CompleteSelection"],
Cell[26491, 840, 203, 6, 29, "Usage",
  CellTags->"CompleteSelection"],
Cell[26697, 848, 323, 6, 50, "Notes",
  CellTags->"CompleteSelection"],
Cell[27023, 856, 264, 9, 22, "Notes",
  CellTags->"CompleteSelection"],
Cell[27290, 867, 517, 11, 70, "Notes",
  CellTags->"CompleteSelection"],
Cell[27810, 880, 150, 3, 70, "Notes",
  CellTags->"CompleteSelection"],
Cell[27963, 885, 214, 4, 70, "Notes",
  CellTags->"CompleteSelection"],
Cell[28180, 891, 621, 19, 70, "Notes",
  CellTags->"CompleteSelection"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28838, 915, 91, 2, 70, "Command",
  CellTags->"TemplateSelection"],
Cell[28932, 919, 221, 6, 70, "Usage",
  CellTags->"TemplateSelection"],
Cell[29156, 927, 578, 16, 70, "Notes",
  CellTags->"TemplateSelection"],
Cell[29737, 945, 718, 18, 70, "Notes",
  CellTags->"TemplateSelection"],
Cell[30458, 965, 485, 13, 70, "Notes",
  CellTags->"TemplateSelection"],
Cell[30946, 980, 616, 17, 70, "Notes",
  CellTags->"TemplateSelection"],
Cell[31565, 999, 681, 19, 70, "Notes",
  CellTags->"TemplateSelection"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

